#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

typedef unsigned short WORD;

struct WordItem
{
    char Chinese[100];
    char English[300];
    char Mark[100];
};

char * chmop(char * source)
{
    char * s = source;
    while ( *s && (*s==' '||*s=='\n'||*s=='\r'||*s=='\t') )
        s++;
    char * returns = s;
    char * end = s+strlen(s)-1;
    while ( end>returns )
    {
        if ( *end==' ' || *end=='\n' || *end=='\r' || *end=='\t' )
            *end='\0';
        else
            break;
        end--;
    }
    return returns;
}

void formatstring(char * source)
{
    char buffer[1024];
    char * s = source;
    while ( *s )
    {
        if (*s=='/')
            *s = '\n';
        s++;
    }
    strcpy(buffer,source);
    strcpy(source,chmop(buffer));
}

void utov(char * source)
{
    char buffer[1024];
    char * s = source;
    char * t = buffer;
    while (*s)
    {
        if ( *s=='u' && *(s+1)==':' )
        {
            *t++ = 'v';
            s++;
        }
        else
            *t++ = *s;
        s++;
    }
    *t = '\0';
    strcpy(source,buffer);
}

int mycompare(const void * s1, const void * s2)
{
    assert(s1!=NULL && s2!=NULL);
    unsigned char * c1 = (unsigned char *)((*(WordItem**)s1)->Chinese);
    unsigned char * c2 = (unsigned char *)((*(WordItem**)s2)->Chinese);
    int i;
	for(i=0;c1[i]!='\0' && c2[i]!='\0';i++)
	{
    	if (c1[i] > c2[i]) return (1);
    	else if (c1[i] < c2[i]) return (-1);
	}

	if(c1[i]!='\0') return(1); 	// c2[i] must be '\0' so c1>c2
	else if(c2[i]!='\0') return(-1);// c1[i] must be '\0' so c1<c2
	else return(0);	// c1[i]=='\0' and c2[i]=='\0',so c1==c2
}

int main(int argc,char **argv)
{
    FILE *input, *output;
    char Buffer[1024],*string[2];
    struct WordItem * OutBuffer[65536];
    int icount=0;
    WORD count;
    WORD a,b;
    if (!(input = fopen("/home/r59182/Install/Chinese/dict/cedict/cedict.gb", "r")))
    {
        fprintf(stderr,"Input File not found\r\n");
        return -2;
    }
    /* Open output file */
    if (!(output = fopen("../dic/cedictgb.dic", "wb")))
    {
        fprintf(stderr,"Unable to open outfile\r\n");
        fclose(input);
        return -3;
    }
    //get count
    
    while (fgets(Buffer,1024,input))
    {
        char * search = Buffer;
        int BufferLen = strlen(Buffer);
        int searchcount=0;
        while ( search<Buffer+BufferLen && searchcount<2 )
        {
            if ( *search=='[' || *search==']' )
            {
                *search='\0';
                string[searchcount]=search+1;
                searchcount++;
            }
            search++;
        }
        if (searchcount==2)
        {
            OutBuffer[icount]= new WordItem;
            strcpy(OutBuffer[icount]->Chinese,chmop(Buffer));
            strcpy(OutBuffer[icount]->English,chmop(string[1]));
            strcpy(OutBuffer[icount]->Mark,chmop(string[0]));
            formatstring(OutBuffer[icount]->English);
            utov(OutBuffer[icount]->Mark);
            icount++;
        }
    }
    qsort(OutBuffer,icount,sizeof(WordItem*),mycompare);
    for(int writecount=0;writecount<icount;writecount++)
    {
        fwrite(OutBuffer[writecount]->Chinese,sizeof(char),strlen(OutBuffer[writecount]->Chinese)+1,output);
        fwrite(OutBuffer[writecount]->English,sizeof(char),strlen(OutBuffer[writecount]->English)+1,output);
        fwrite(OutBuffer[writecount]->Mark,sizeof(char),strlen(OutBuffer[writecount]->Mark)+1,output);
        delete OutBuffer[writecount];
    }
    fwrite(&icount,sizeof(int),1,output);
    int style= (0<<24) + (1<<16) + (0<<8) + 3;
    fwrite(&style,sizeof(int),1,output);

    fclose(input);
    fclose(output);
}
