/*
	writer	: Ma Su An
	E-Mail	: msa@wri.com.cn
	
	Copyright by Ma Su An.
	All rights reserved.
	Permission to use ,copy,modify,and distribute this software for
	individual use and without fee is granted with that condition:

    	Every copy of this software must have the writer's name displayed 
	on the top label.
*/

// filename : trans.h
// msa 1999.1

#ifndef TRANS_H
#define TRANS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef NDEBUG
#define DEBUGVERSION
#else
#define DEBUGVERSION " [Debug Version]"
#endif

#ifndef VERSION
#define VERSION "1.35+"
#endif

#include <assert.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <time.h>
//#include <fcntl.h>
#include <limits.h>         // for PATH_MAX etc (opera add)
#ifdef HAVE_SYS_AUXV_H
#include <sys/auxv.h>       // to test if getexecname can be used
#endif
#include <stdlib.h>
//#include <sys/stat.h>
#include <strings.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include <Xm/CutPaste.h>
#include <Xm/DialogS.h>
#include <Xm/Protocols.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>
#include <Xm/List.h>
#include <Xm/Frame.h>
#include <Xm/ToggleB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#include <Xm/ArrowB.h>
#include <Xm/RowColumn.h>
#include <X11/extensions/shape.h>
#include <X11/cursorfont.h>
#include "regdef.h"
#include "trayicon.h"
#include "libs.h"

#ifdef  AT_SUN_EXECNAME
#define SCROLL_BAR_EXT_WIDTH 6
#else
#define SCROLL_BAR_EXT_WIDTH 8
#endif

//#define ALL_BG_PIXMAP
//#define USE_MY_GET_SELECTION
//#undef XmNrenderTable

extern const char* const BUILD_DATE_S;

const int CONFIG_VERSION_ID=2;
const int MAX_HIS_NUM=15;
const int MAX_MATCH_ITEM=100;
const int MAX_FUZZY_MATCH_ITEM=100;
const unsigned char MAX_FUZZY_DISTANCE='\3'; // at most MAX_FUZZY_DISTANCE-1 differences allowed when find similar words
const int SELECTION_INTERVAL=250; 		    // check selection interval.
const long SELECTION_TIMEOUT=SELECTION_INTERVAL*5L; // XtGetSelectionValue timeout.
const int FLOAT_TIMEOUT=300;		        // interval used by float window.
const int OFFSETX=8;
const int OFFSETY=0;
const int STICK_HEIGHT=6;
const int DISAPPEAR_DISTANCE=1024;
const BYTE MAX_NOSELTIME_COUNT=1;
const int MAX_COLOR_LOST=0;

const int FLOAT_SHOW_LEVEL_ALL=0;
const int FLOAT_SHOW_LEVEL_ONLYFIRST=1;
const int FLOAT_SHOW_LEVEL_NONE=2;
const int FLOAT_SHOW_LEVEL_NONE_ONLYFIRST=3;

const char* const HZFONT_S="hz16";
const char* const HZFONT_FT_S="hz16ft";
const char* const YBFONT_S="yb10x20";
const char* const FONTDIR_S="hzfont";
const char* const HISTORY_S="ʷ";
const char* const CURRENT_S="ǰ";
const char* const SCAN_S="Ļѡȡ";
const char* const HELP_S="";
const char* const EXIT_S="˳";
const char* const LAST_S="һ";
const char* const NEXT_S="һ";
const char* const BACKIMAGEFILE_S="images/back.gif";
const char* const BACKIMAGEFILE_WHITE_S="images/back_white.gif";
const char* const ICONIMAGEFILE_S="images/icon.gif";
const char* const ICONMASKFILE_S="images/iconmask.xbm";
const char* const HELPIMAGEFILE_S="images/help.gif";
const char* const HELPMASKFILE_S="images/helpmask.xbm";
const char* const EXITIMAGEFILE_S="images/exit.gif";
const char* const EXITMASKFILE_S="images/exitmask.xbm";
const char* const LASTIMAGEFILE_S="images/last.gif";
const char* const LASTMASKFILE_S="images/lastmask.xbm";
const char* const NEXTIMAGEFILE_S="images/next.gif";
const char* const NEXTMASKFILE_S="images/nextmask.xbm";
const char* const FLOAT_STICK_NO_S="images/stick_no.gif";
const char* const FLOAT_STICK_YES_S="images/stick_yes.gif";
const char* const FUZZY_FIND_FILE_S="images/find.gif";
const char* const FUZZY_FIND_MASK_FILE_S="images/findmask.xbm";
const char* const TRAYICON_IMAGEFILE_S="images/trayicon.gif";
const char* const TRAYICON_SCAN_IMAGEFILE_S="images/trayicon_scan.gif";
const char* const TRAYICON_MASKFILE_S="images/trayiconmask.xbm";

const char* const ONLYONE="_ONLY_ONE_STAR_DICT_1";

class WordItem;
class Lib;
class ListWin;
class Selection;
class FloatWin;
class HistoryList;
class UserWin;
class AppCore;
class AppFrame;

extern char sErrorMessage[];

//=============================================================================
class ListWin
{
private:
	AppCore* poAppCore;
	Widget wList;		// list to contain history or current Lib words.

	static void vChooseCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vClickCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vChoose(XmString xmsWord);
	void vClick(XmString xmsWord,int);
public:
	ListWin(AppCore* pAppCore);
	Widget wCreate(Widget wParent);
	void vSetBackground(Pixmap pixBack);
	void vClear();
	void vInsertLast(const char* sNewItem);
	void vInsertFirst(const char* sNewItem);
	void vDeleteFirst(int iCount);
	void vDeleteLast(int iCount);
	int iVisibleCount();
	int iLength();
};

//=============================================================================
class HistoryList
{
private:
	AppCore* poAppCore;
	Widget wList;
	static void vChooseCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vChoose(XmString xmsWord);
	static void vButtonEventCallback(Widget w,XtPointer thisObj,
		XEvent* , Boolean* );
	void vButtonEvent(Boolean* continue_to);
public:
	HistoryList(AppCore* pAppCore);
	Widget wCreate(Widget wParent);
	void vInsert(const char* sNewItem);
	int iLength();
	void vPopup();
	void vPopdown();
	void vToggle();
#ifdef ALL_BG_PIXMAP
    void vSetBackground(Pixmap pixBack);
#endif
};

//=============================================================================
class UserWin 
{
private:
	AppCore *poAppCore;
	Widget wWordText; 	// the textfield to input word.
	Widget wMeaning;	// meaning label.
	Widget wWordLabel;
	Widget wArrow;

	HistoryList oHistoryList;

	static void vEnterWordCallback(Widget w,XtPointer thisObj,
		XtPointer cbs);
	static void vWordChangeCallback(Widget w,XtPointer thisObj,
		XtPointer cbs);
	static void vArrowCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	void vEnterWord();
	void vWordChange();
	Widget wCreateMeaningWin(Widget wParent);
    static void vPressMeaningCallback(Widget w, XtPointer thisObj, XtPointer call_data);
public:
	UserWin(AppCore *pAppCore);
	Widget wCreate(Widget wParent);
	void vSetBackground(Pixmap pixBack);
	void vClearMeaningWin();
	void vShowToMeaningWin(const char *sMessage);
	void vShowToMeaningWin(const XmString xmsMessage);
	void vShowToLabel(XmString xmsLabelString);
	void vShowToLabel(const char* sWord);
	void vPutToText(const char *sWord);
	void vClearText();
	void vToggleHisList();
	void vInsertHisList(const char* sWord);
	void vActivateText();
    void vShowHelp();
	Boolean bTextSelected();
	void vSetTextSelection();
    const Widget oGetMeaningWidget(){  return wMeaning;  };
};

//=============================================================================
class FloatWin
{
private:
	Widget wShell;
    Widget wForm;
    Widget wScrolledWin;
	Widget wLabel;
    Widget wStick;
    Widget wFuzzyFind;
    WordItem ** oSavedWordItem;
    AppCore* poAppCore;
    int iFloatShowLevel;
	int iRecordX;
	int iRecordY;
	Boolean bMapped;
	void vRecordXY();
	static void vTimeOutCallback(XtPointer thisObj,XtIntervalId *nouse);
	void vTimeOut();
	void vGoTo(int iX,int iY);
    int iGetShowLevel();
    static void vButtonCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to);
    void vButton(Widget w,XEvent * pEvent);
    void vDrawStick();
    bool bIsSavedWordItemValid,bIsSavedMessageValid;
    int iSavedShowStates;
    bool bIsLocked;
    bool bInMoving,bHaveScrollBar;
    Dimension iScrollBarWidth,iScrollBarHeight;
    XmString xmsSavedMessage;
    char sSavedWords[MAX_STR_LEN+1];
    Pixmap pixStick_no,pixStick_yes;
public:
	FloatWin(AppCore* pAppCore);
	~FloatWin();
	void vSetBackground(Pixmap pixBack);
	Widget wCreate(Widget wParent);
	void vShow(const char * sWord, const XmString xmsMessage,const Boolean ShowFuzzyFindButton);
    void vShow(const WordItem ** ppWordToShow);
	void vPopup();
	void vPopdown();
	void vGoToRecordedXY();
};

//============================================================================
class Selection
{
private:
	AppCore* poAppCore;
	Widget w;
	char sLastClipWord[MAX_STR_LEN+1];
    BYTE cNoSelTimeCount;
    static Atom TARGETS_Atom,UTF8_STRING_Atom,LOCALE_ENCODING_Atom,COMPOUND_TEXT_Atom,TEXT_Atom;
    BYTE cIsBusy;
    bool bIsEnding;

	static void vTimeOutCallback(XtPointer thisObj,XtIntervalId *nouse);
	static void vSelectionCallback(Widget w,XtPointer thisObj,
		Atom *selection,Atom *type,XtPointer value,
		unsigned long *length,int *format);
    static void vSelectionTypeCallback(Widget ,XtPointer thisObj,Atom *,
	    Atom *,XtPointer value,unsigned long *length,int *);
	void vSelectionReceived(char* sValue,int iLength,int iType);
	void vTimeOut();
	Boolean bEnable();
public:
	Selection(AppCore* pAppCore);
	void vStart(Widget wToUse);
    void vEnd();
};

//============================================================================
class CfgWin
{
private:
	AppCore* poAppCore;
	Widget wUseRuleToggle;
	Widget wScanClipBoardToggle;
	Widget wHelpButton;
	Widget wExitButton;
	Widget wLastButton;
	Widget wNextButton;
	static void vHelpCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vExitCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vLastCallback(Widget w,XtPointer thisObj,XtPointer cbs);
	static void vNextCallback(Widget w,XtPointer thisObj,XtPointer cbs);
    static void vScanClipBoardCallback(Widget w,XtPointer thisObj,XtPointer cbs);
public:
	CfgWin(AppCore* pAppCore);
	Boolean bScanClipBoard(); // whether to scan clipboard.
    Boolean bSetScanClipBoard(Boolean NewState);
	Widget wCreate(Widget wParent);
	void vSetBackground(Pixmap pixBack);
	void vSetButtonPixmap();
    void vSaveConfig();
};

//============================================================================
class AppCore
{
private:
	AppFrame* poAppFrame;
	int * iCurrentIndex;
    char * sSavedWords;
    
    // struct
    struct Fuzzystruct {
        const char * pMatchWord;
        int iMatchWordDistance;
    };
    int iMaxFuzzyDistance;
    
	// view
	Widget wTopLabel;
	UserWin oUserWin;
	ListWin oListWin;
	CfgWin oCfgWin;
	FloatWin oFloatWin;

	Selection oSelection;

	bool bSetBackground(bool UsePicture);
	Widget wCreateTopLabel(Widget wParent);
	void vSimpleLookupToUserWin(const char* sWord,int* piIndex=NULL,int iSimularDirection=SEARCH_INDEX_DOWN,int iSearchType=STRING_TYPE_ASCII);
	void vLookupWithRuleToUserWin(const char* sWord);
    void vLookupMeaningToUsrWin(const char * sWord);
    void vLookupWithFuzzyToUserWin(const char *sWord);
	void vListWords(int *iStartIndex,const BYTE cListType,const Boolean bChangeIndex);
	void vShowWordToUserWin(WordItem ** ppWordToShow,const char * sOriginWord);
	void vShowWordToFloat(const WordItem ** ppWordToShow);
	void vFillList(int * iIndex,const BYTE cListType,const Boolean bChangeIndex);
    static void vColorMapChangeCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to);
    void vColorMapchange(XEvent * pEvent);
    static int mycompare(const void * s1, const void * s2);
public:
	AppCore(AppFrame* pAppFrame);
    ~AppCore();
	Widget wCreate(Widget wParent);
	Boolean bScreenFetchEnable();
    Bool bScanClipBoard();
    Bool bSetScanClipBoard(Bool NewState);
    AppFrame * pGetAppFrame();
	void vShowHelp();
	void vArrowActivate();
	void vQuit();
    void vEnd();
	void vAfterRealize();
	void vNext();
	void vLast();

	void vShowNotFoundToFloat(const char* sWord,const char* sReason,const Boolean ShowFuzzyFindButton);
	void vShowNotFoundToUserWin(const char* sWord,const char* sReason);
    void vLookupWithFuzzyToFloatWin(const char * sWord);
	void vUserWinEnterWord(const char* sWord);
	void vUserWinWordChange(const char* sWord,int iSimularDirection,int * piInput_Index);
	void vHistoryChoose(const char* sWord);
	void vListClick(const char* sWord);
	void vListChoose(const char* sWord);
  	Boolean vSimpleLookupToFloat(const char* sWord,int iType,Boolean bShowIfNotFound);
    void vPressMeaning(Time eventtime);
	XmString * oWordsToShow(WordItem ** ppWordToShow,const Boolean bSaveWords,const bool bOnlyFirstLib);
    void vPopup();
    void vProcessXEvent();
};

//============================================================================
class AppFrame
{
private:
	XtAppContext app;
	Widget wToplevel;
    
    TrayIcon oTrayIcon;
    bool m_intray;
    Window iconWin;
    Widget popup_menu;
    bool m_quit;
    int m_state;
    Position m_XPos,m_YPos;
    Dimension m_Width,m_Height;

	AppCore oAppCore;

	static void vDeleteCallback(Widget w,XtPointer thisObj,XtPointer cbs);
    static void vTrayMessageCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to);
    static void vUnmapCallback(Widget w,XtPointer thisObj,XEvent* pEvent, Boolean* continue_to);
    static void vRButtonPopupCallback(Widget menu_item, XtPointer client_data, XtPointer call_data);
    static void vMenuUnmapCallback(Widget menu_item, XtPointer client_data, XtPointer call_data);
    void vDeleteRButtonMenu(void);
	void vSetIcon();
    void vSetTrayIcon(void);
	void vSetFontPath();
	void vRaiseUp();
    void vSetState();
    void vGetState();
    void vPutToCurrentWorkSpace();
public:
	AppFrame();
    ~AppFrame();
	void vInit(int argc,char **argv);
	void vQuit();
	void vLoop();
    void vPopup();
    void vProcessXEvent();
    void vUpdateScanState(Bool state);
    void vToggleScanSelection();
};

//============================================================================
void vShowErrorToTerm(const char *sMessage);
XmString xmsCreateChinese(const char *sWord);
Boolean bGetExecDir();
Pixmap pixCreatePixmap(Widget w,const char *sImageFile,int* piColorLost);
Pixmap pixGetPixmap(Widget w,const char *sImageFile);
Pixmap pixForceGetPixmap(Widget w,const char *sImageFile);
Pixmap pixGetBitmap(Widget w,const char *sImageFile);
extern bool bIsChinese(char ch);
Boolean bHaveFont(Display* display,const char* sFontName);
Boolean bDirOK(const char* sPath);
void vGetPointerXY(Display* display,int& iX,int& iY,Window& childwindow);
Boolean bContainRule(const char* sWord);
int main(int argc,char **argv);
char* sChangeTo2Byte(const char* sMessage);
char* sReturnTo1Byte(const char* sMessage);
const char * UnicodeToUTF8(int * ch);
void vString2UniString(const char * source, int * dest);
inline void vFreeSelectionMemory(XtPointer memory);
static Atom GetLocaleEncodingAtom(Display *dpy);
static int iWindowState(Widget w);
void vInitCommonData(void);
void vCommandLineLoop(void);
#ifdef NDEBUG
static void signal_handler(int whatsig);
#endif
#ifdef XmNrenderTable
Pixel ConvertStringToPixel (Widget widget, char *name);
void vCreateRendertable(Widget wWidget);
#endif
/************************************* END ***********************************/
	
#endif
