#include "config.h"
#include "sessionmanager.h"
#include "client.h"
#include "debug.h"


SessionManager sessionManager;


SessionManager::SessionManager()
{
	Socket::socketRegistry = &socketRegistry;
	
	clientList = NULL;
}

SessionManager::~SessionManager()
{
	if (dbConn)
		dbConn->destroy();

	while (clientList) {
		Client *c = clientList;
		clientList = clientList->next;
		delete c;
	}
}

bool SessionManager::initDB()
{
	string name = LINQ_LIB_DIR"/db/";
	name += option.db_impl;

	if (!dbModule.load(name.c_str())) {
		ICQ_LOG("Can not load db module: %s\n", name.c_str());
		return false;
	}

	dbConn = dbModule.getConn();
	if (!dbConn)
		return false;

	DB_INFO *info = &option.db_info;
	if (!dbConn->init(
		info->host.c_str(),
		info->user.c_str(),
		info->passwd.c_str(),
		info->db.c_str(),
		info->port))
		return false;

	return true;
}

bool SessionManager::init(int argc, char *argv[])
{
	srand(time(&curTime));

	option.load(argc, argv);

	if (!initDB())
		return false;

	if (!createSocket(SOCK_STREAM))
		return false;

	if (!bindAddress(option.ip, option.port)) {
		ICQ_LOG("Can not bind on port\n");
		return false;
	}

	listen(sockfd, 5);
	addEvent(SOCKET_READ);

	ICQ_LOG("sm is now started\n");
	return true;
}

void SessionManager::run()
{
	while (true) {
		curTime = time(NULL);

		if (!socketRegistry.poll(curTime))
			break;
	}
}

void SessionManager::removeClient(Client *c)
{
	Client *p = clientList;
	if (p == c)
		clientList = clientList->next;
	else {
		while (p && p->next != c)
			p = p->next;
		if (p)
			p->next = p->next->next;
	}
	delete c;
}

void SessionManager::addSession(Session *s)
{
	ICQ_LOG("%s is added\n", s->userName);

	sessionHash.put(s);
}

Session *SessionManager::getSession(const char *name)
{
	return sessionHash.get(name);
}

bool SessionManager::onSocketRead()
{
	int fd = accept(sockfd, NULL, NULL);
	if (fd < 0)
		return false;

	Client *c = new Client(fd);

	ICQ_LOG("accept new server\n");

	c->next = clientList;
	clientList = c;
	return true;
}
