#include "config.h"
#include "SearchDlg.h"
#include "LinqMain.h"
#include "intl.h"

#include <stdio.h>

LinqSearchResult::LinqSearchResult(SEARCH_RESULT &result)
{
	name = result.name;
	status = result.status;
	nick = result.nick;
	auth = result.auth;
	gender = result.gender;
	age = result.age;
}

SearchDlg::SearchDlg() : LinqWindow(WIN_SEARCH)
{
	window = NULL;
}

SearchDlg::~SearchDlg()
{
	clean_search_user_result();
	
	if (window)
		gtk_widget_destroy(window);
}

void SearchDlg::Show()
{
	if (window) {
		gtk_window_present(GTK_WINDOW(window));
		return;
	}
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	g_signal_connect (G_OBJECT (window), "delete_event",
			    G_CALLBACK(on_window_deleteevent), this);
	gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
	gtk_window_set_title (GTK_WINDOW (window), _("Search"));
	gtk_container_set_border_width (GTK_CONTAINER (window), 8);

	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add (GTK_CONTAINER (window), vbox);

	create_notebook();
	gtk_box_pack_start(GTK_BOX(vbox), notebook,FALSE,FALSE,10);
	GtkWidget *separator;
	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 10);
					
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE,10);
	back_button = gtk_button_new_with_label(_("< Back"));
	gtk_widget_set_sensitive(back_button,FALSE);
	gtk_box_pack_start_defaults(GTK_BOX(hbox),back_button);
	g_signal_connect (G_OBJECT (back_button), "clicked",
		    G_CALLBACK(on_back_clicked), this);
	next_button = gtk_button_new_with_label(_("Next >"));
	gtk_box_pack_start_defaults(GTK_BOX(hbox),next_button);
	g_signal_connect (G_OBJECT (next_button), "clicked",
		    G_CALLBACK(on_next_clicked), this);
	cancel_button = gtk_button_new_with_label(_("Cancel"));
	g_signal_connect (G_OBJECT (cancel_button), "clicked",
			    G_CALLBACK(on_cancel_clicked), this);
	gtk_box_pack_start_defaults(GTK_BOX(hbox),cancel_button);
	gtk_box_pack_start_defaults(GTK_BOX(vbox),hbox);
	
	gtk_widget_show_all(window);
}

gboolean SearchDlg::on_window_deleteevent (GtkWidget * widget, GdkEvent * event, SearchDlg *oSearchDlg)
{
	delete oSearchDlg;
	return true;
}

void SearchDlg::on_back_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{
	SearchPage back_page;
	switch (oSearchDlg->nb_current_page)
	{
		case NB_CUSTOM_SEARCH:
			back_page = NB_CHOOSE;
			break;
		case NB_USER_LIST:
			if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_RANDOM_SEARCH)
				back_page = NB_CHOOSE;
			else if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_CUSTOM_SEARCH)
				back_page = NB_CUSTOM_SEARCH;
			else if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
				back_page = NB_SERVER_LIST;
			else
				back_page = NB_CHOOSE;
			break;
		case NB_ADD_FRIEND:
			back_page = NB_USER_LIST;
			break;
		case NB_GROUP_TYPE_LIST:
			back_page = NB_CHOOSE;
			break;
		case NB_GROUP_LIST:
			if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_LIST)
				back_page = NB_GROUP_TYPE_LIST;
			else if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_NUM)
				back_page = NB_GROUP_NUM;
			else
				back_page = NB_CHOOSE;
			break;
		case NB_CREATE_GROUP:
			back_page = NB_GROUP_TYPE_LIST;
			break;
		case NB_CREATE_GROUP_RESULT:
			if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_LIST)
				back_page = NB_GROUP_LIST;
			else if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_GROUP_NUM)
				back_page = NB_GROUP_LIST;
			else if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_CREATE_GROUP)
				back_page = NB_CREATE_GROUP;
			else
				back_page = NB_CHOOSE;
			break;
		case NB_GROUP_NUM:
			back_page = NB_CHOOSE;
			break;
		default:
			back_page = NB_CHOOSE;
	}
	gtk_notebook_set_current_page (GTK_NOTEBOOK (oSearchDlg->notebook), back_page);
	oSearchDlg->nb_current_page = back_page;	
	if (oSearchDlg->nb_current_page==NB_CHOOSE)
		gtk_widget_set_sensitive(oSearchDlg->back_button,FALSE);
}

void SearchDlg::clean_search_user_result ()
{
	std::list< std::list< LinqSearchResult > * >::iterator iter;
	for (iter = searchUserResultPageList.begin(); iter != searchUserResultPageList.end(); ++iter) {
		delete (*iter);
	}
	searchUserResultPageList.clear();

	gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(user_list_treeview))));
	gtk_label_set_text(GTK_LABEL(user_list_info_label),_("Searching..."));
	gtk_widget_set_sensitive(user_list_previous_button,FALSE);
	gtk_widget_set_sensitive(user_list_next_button,FALSE);
	gtk_widget_set_sensitive(user_list_all_button,FALSE);
	search_user_result_current_page = -2; //so it is not equal to -1 and 0,1,2,3....so can do a fresh.
}

/*
static void
search_dialog_clean_search_group_result (struct search_dialog *sd)
{
	struct search_group_info *group;
	while (sd->search_group_list)
	{
		group = (struct search_group_info *)(sd->search_group_list->data);
		g_free(group->name);
		g_free(group);
		sd->search_group_list = g_slist_remove(sd->search_group_list,group);
	}

	gtk_list_store_clear(GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->group_list_treeview))));
	gtk_label_set_text(GTK_LABEL(sd->group_list_info_label),_("Searching..."));
}

static void
search_dialog_clean_search_server_result (struct search_dialog *sd)
{
	struct search_server_info *server;
	while (sd->search_server_list)
	{
		server = (struct search_server_info *)(sd->search_server_list->data);
		g_free(server->domain);
		g_free(server->desc);
		g_free(server);
		sd->search_server_list = g_slist_remove(sd->search_server_list,server);
	}
}
*/

void SearchDlg::refresh_search_user_result (gint refresh_page)
{
	std::list< std::list< LinqSearchResult > * >::iterator page_iter;

	if (refresh_page==search_user_result_current_page)
		return;
		
	gint total_page;
	total_page= searchUserResultPageList.size();
	page_iter = searchUserResultPageList.begin();
	if (refresh_page!=-1) //all page.
		for (int i=0; i<refresh_page;i++)
			++page_iter;

	GtkListStore *list_store;
	list_store=GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(user_list_treeview)));
	gtk_list_store_clear(list_store);
	GtkTreeIter iter;
	std::list< LinqSearchResult >::iterator result_iter;
	while (page_iter != searchUserResultPageList.end())
	{
		result_iter = (*(*page_iter)).begin();
		while (result_iter != (*(*page_iter)).end()) {
			LinqSearchResult *result;
			result = &(*result_iter);
			gtk_list_store_append (list_store, &iter);
			gtk_list_store_set (list_store, &iter,
			  	0, result->name.c_str(),
				1, result->nick.c_str(),
				2, result->status,				
				3,result->auth,
				4,result->gender,
				5,result->age,
				-1);
			++result_iter;
		}
		if (refresh_page==-1)
			++page_iter;
		else
			page_iter = searchUserResultPageList.end();
	}
	if (refresh_page==total_page-1) //the last page
	{
/*		page_list = g_slist_last(sd->search_user_result_page_list);
		user_info_list = (GSList *)(page_list->data);
		if (!user_info_list) //find no user.
		{
			sd->customSearch_startUIN = -1;
		}
		else
		{
			user_info_list = g_slist_last(user_info_list);
			user = (struct search_user_info*)(user_info_list->data);			
			sd->customSearch_startUIN = user->uin; //the last user has the max number.
		}*/
	}

	gchar text[256];
	if (refresh_page != -1)
		sprintf(text,_("Result of page %d(%d)"),refresh_page+1,total_page);
	else
		sprintf(text,_("All result(%d page in total)"),total_page);
	gtk_label_set_text(GTK_LABEL(user_list_info_label), text);
	if (refresh_page!=0)
		gtk_widget_set_sensitive(user_list_previous_button,TRUE);
	else
		gtk_widget_set_sensitive(user_list_previous_button,FALSE);
	gtk_widget_set_sensitive(user_list_next_button,TRUE);
	gtk_widget_set_sensitive(user_list_all_button,TRUE);	
	
	search_user_result_current_page = refresh_page;
	//gtk_window_present(GTK_WINDOW(window));
}

/*
void
search_dialog_refresh_search_group_result (struct search_dialog *sd)
{
	GSList *group_info_list;
	struct search_group_info *group;
	GtkListStore *list_store;
	GtkTreeIter iter;
	
	list_store=GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->group_list_treeview)));
	gtk_list_store_clear(list_store);
	group_info_list = sd->search_group_list;
	while (group_info_list)
	{
		group = (struct search_group_info*)(group_info_list->data);
		gtk_list_store_append (list_store, &iter);
		gtk_list_store_set (list_store, &iter,
			  	0, group->id,
				1,group->name,
				2,group->num,
				-1);
		group_info_list = g_slist_next(group_info_list);
	}
	gtk_label_set_text(GTK_LABEL(sd->group_list_info_label),_("Completed"));
}

void
search_dialog_refresh_search_server_result (struct search_dialog *sd)
{
	GSList *server_info_list;
	struct search_server_info *server;
	GtkListStore *list_store;
	GtkTreeIter iter;
	
	list_store=GTK_LIST_STORE(gtk_tree_view_get_model(GTK_TREE_VIEW(sd->server_list_treeview)));
	gtk_list_store_clear(list_store);
	server_info_list = sd->search_server_list;
	while (server_info_list)
	{
		server = (struct search_server_info*)(server_info_list->data);
		gtk_list_store_append (list_store, &iter);
		gtk_list_store_set (list_store, &iter,
			  	0, server->domain,
				1,server->sessionCount,
				2,server->desc,
				-1);
		server_info_list = g_slist_next(server_info_list);
	}
	gtk_label_set_text(GTK_LABEL(sd->server_list_label),_("Completed"));
}


static void
search_dialog_destroy (GtkWidget * widget, struct search_dialog *sd)
{
	struct myicq_data *md = sd->gc->proto_data;
	search_dialog_clean_search_user_result(sd);
	search_dialog_clean_search_server_result(sd);
	search_dialog_clean_search_group_result(sd);
	g_free(sd);
	md->searchDlg = NULL;
}
*/

SearchDlg::SearchPage SearchDlg::nb_user_list_next ()
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (user_list_treeview)), &model, &iter))
	{
		/*gchar *nick;
		gtk_tree_model_get (model, &iter,0,&nick,-1);
		gtk_label_set_text(GTK_LABEL(add_friend_nick_label),nick);	*/
		gtk_label_set_text(GTK_LABEL(add_friend_info_label),_("Waiting the add friend reply..."));			
		gtk_widget_hide(add_friend_hbox);
		if (nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
		{
			/*GtkTreeModel *serv_list_model;
			GtkTreeIter serv_list_iter;	
			if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->server_list_treeview)), &serv_list_model, &serv_list_iter))
			{
				gchar *domain;
				gchar *uin;
				gchar *bud;
				gtk_tree_model_get (serv_list_model, &serv_list_iter,0,&domain,-1);						
				gtk_tree_model_get (model, &iter,1, &uin,-1);
				bud = g_strdup_printf("%s@%s",uin,domain);
				gtk_label_set_text(GTK_LABEL(sd->add_friend_uin_label),bud);		
				myicq_send_packet_addfriend(sd->gc,bud);
				g_free(domain);
				g_free(uin);
				g_free(bud);
			}*/
		}
		else
		{
			gchar *name;
			gtk_tree_model_get (model, &iter,0, &name,-1);
			gtk_label_set_text(GTK_LABEL(add_friend_uin_label),name);		
			linqMain->getUDPSession()->addContact(name);
			g_free(name);
		}
	}
	else
	{
		//do_error_dialog(_("Error"), _("Please select one user!"), GAIM_ERROR);
		return NB_NULL;
	}

	return NB_ADD_FRIEND;
}

SearchDlg::SearchPage SearchDlg::nb_server_list_next ()
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (server_list_treeview)), &model, &iter))
	{
		/*gchar *domain;
		gtk_tree_model_get (model, &iter,0,&domain,-1);
		search_dialog_clean_search_user_result(sd);
		myicq_send_packet_searchRandom(domain,sd->gc);
		g_free(domain);*/
	}
	else
	{
		//do_error_dialog(_("Error"), _("Please select one server!"), GAIM_ERROR);
		return NB_NULL;
	}

	return NB_USER_LIST;
}

SearchDlg::SearchPage SearchDlg::nb_group_list_next ()
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (group_list_treeview)), &model, &iter))
	{
		/*uint32 id;
		gtk_label_set_text(GTK_LABEL(sd->create_group_result_info_label),_("Waiting the enter group reply..."));
		gtk_tree_model_get (model, &iter,0,&id,-1);
		myicq_send_packet_enterGroup(id,gtk_entry_get_text(GTK_ENTRY(sd->group_list_password_entry)),sd->gc);*/
		return NB_CREATE_GROUP_RESULT;
	}
	else
	{
		//do_error_dialog(_("Error"), _("Please select one group!"), GAIM_ERROR);
		return NB_NULL;
	}
}

SearchDlg::SearchPage SearchDlg::nb_group_type_list_next ()
{
	GtkTreeModel *model;
	GtkTreeIter iter;	
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (group_type_list_treeview)), &model, &iter))
	{
		if (nb_choose_radio == NB_CHOOSE_RADIO_GROUP_LIST)
		{
			/*gint type;
			gtk_tree_model_get (model, &iter,2,&type,-1);
			search_dialog_clean_search_group_result(sd);
			myicq_send_packet_getGroupList(type,sd->gc);
*/
			return NB_GROUP_LIST;
		}
		else if (nb_choose_radio == NB_CHOOSE_RADIO_CREATE_GROUP)
		{
			return NB_CREATE_GROUP;
		}
		else
		{
			return NB_CHOOSE;
		}
	}
	else
	{
		//do_error_dialog(_("Error"), _("Please select one group type!"), GAIM_ERROR);
		return NB_NULL;
	}
}

SearchDlg::SearchPage SearchDlg::nb_create_group_next ()
{
	const gchar *text;
	text = gtk_entry_get_text(GTK_ENTRY(create_group_name_entry));
	if (text[0])
	{
		GtkTreeModel *model;
		GtkTreeIter iter;	
	
		if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (group_type_list_treeview)), &model, &iter))
		{
			/*uint16 type;
			gchar *name;
			
			gtk_tree_model_get (model, &iter,2,&type,-1);
			gtk_label_set_text(GTK_LABEL(sd->create_group_result_info_label),_("Waiting the create group reply..."));
			name = g_locale_from_utf8(text,-1,NULL,NULL,NULL);
			myicq_send_packet_createGroup(type, name, gtk_entry_get_text(GTK_ENTRY(sd->create_group_password_entry)), sd->gc);*/
			return NB_CREATE_GROUP_RESULT;
		}
		else
			return NB_CHOOSE;	
	}
	else
	{
		//do_error_dialog(_("Input error"), _("Please input the group name!"), GAIM_ERROR);
		return NB_NULL;
	}
}

SearchDlg::SearchPage SearchDlg::nb_group_num_next ()
{
	uint32 id;
	id = atol(gtk_entry_get_text(GTK_ENTRY(group_num_entry)));
	if (id>0)
	{
		//search_dialog_clean_search_group_result(sd);
		//myicq_send_packet_searchGroup(id,sd->gc);
		return NB_GROUP_LIST;
	}
	else
	{
		//do_error_dialog(_("Input error"), _("Please input the group number!"), GAIM_ERROR);
		return NB_NULL;
	}
}

void SearchDlg::on_next_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{
	SearchPage next_page = NB_CHOOSE;
	switch (oSearchDlg->nb_current_page)
	{
		case NB_CHOOSE:			
			if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (oSearchDlg->radio_online_user)))
			{
				next_page=NB_USER_LIST;
				oSearchDlg->nb_choose_radio = NB_CHOOSE_RADIO_RANDOM_SEARCH;				
				oSearchDlg->clean_search_user_result();
				linqMain->getUDPSession()->searchRandom();
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (oSearchDlg->radio_custom_search)))
			{
				next_page=NB_CUSTOM_SEARCH;
				oSearchDlg->nb_choose_radio = NB_CHOOSE_RADIO_CUSTOM_SEARCH;
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (oSearchDlg->radio_remote_friend)))
			{
				next_page=NB_SERVER_LIST;
				oSearchDlg->nb_choose_radio = NB_CHOOSE_RADIO_REMOTE_FRIEND;
				//if (!sd->have_server_list)
				//	myicq_send_packet_getServerList(sd->gc);
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (oSearchDlg->radio_group_list)))
			{
				next_page=NB_GROUP_TYPE_LIST;
				oSearchDlg->nb_choose_radio = NB_CHOOSE_RADIO_GROUP_LIST;
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (oSearchDlg->radio_group_num)))
			{
				next_page=NB_GROUP_NUM;
				oSearchDlg->nb_choose_radio = NB_CHOOSE_RADIO_GROUP_NUM;
			}
			else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (oSearchDlg->radio_create_group)))
			{
				next_page=NB_GROUP_TYPE_LIST;
				oSearchDlg->nb_choose_radio = NB_CHOOSE_RADIO_CREATE_GROUP;
			}
			break;
		case NB_CUSTOM_SEARCH:
			if ((gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_name_entry))[0]=='\0')&&(gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_nick_entry))[0]=='\0')&&(gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_email_entry))[0]=='\0'))
			{
				GtkWidget *dialog = gtk_message_dialog_new(GTK_WINDOW(oSearchDlg->window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _("Please input some information to search!"));			
				g_signal_connect_swapped (GTK_OBJECT (dialog), "response", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog));
				gtk_widget_show (dialog);
				return;
			}
			else
			{
				oSearchDlg->clean_search_user_result();
				linqMain->getUDPSession()->searchUser(gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_name_entry)),gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_nick_entry)),gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_email_entry)));
				next_page = NB_USER_LIST;
			}
			break;
		case NB_USER_LIST:
			next_page = oSearchDlg->nb_user_list_next();
			if (next_page == NB_NULL)
				return;
			break;
		case NB_SERVER_LIST:
			next_page = oSearchDlg->nb_server_list_next();
			if (next_page == NB_NULL)
				return;
			break;
		case NB_GROUP_TYPE_LIST:
			next_page = oSearchDlg->nb_group_type_list_next();
			if (next_page == NB_NULL)
				return;
			break;
		case NB_GROUP_LIST:
			next_page = oSearchDlg->nb_group_list_next();
			if (next_page == NB_NULL)
				return;
			break;
		case NB_CREATE_GROUP:
			next_page = oSearchDlg->nb_create_group_next();
			if (next_page == NB_NULL)
				return;
			break;
		case NB_GROUP_NUM:
			next_page = oSearchDlg->nb_group_num_next();
			if (next_page == NB_NULL)
				return;
			break;
		default:
			next_page = NB_CHOOSE;
	}
	gtk_notebook_set_current_page (GTK_NOTEBOOK (oSearchDlg->notebook), next_page);
	oSearchDlg->nb_current_page = next_page;	
	gtk_widget_set_sensitive(oSearchDlg->back_button,TRUE);
}

void SearchDlg::on_cancel_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{
	delete oSearchDlg;
}

void SearchDlg::create_nb_choose()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE,8);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Please choose"));
	GtkWidget *vbox1;
	vbox1 = gtk_vbox_new(FALSE,6);
	radio_online_user = gtk_radio_button_new_with_label(NULL,_("Random search online user"));
	gtk_box_pack_start(GTK_BOX(vbox1),radio_online_user,FALSE,FALSE,0);
	radio_custom_search = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio_online_user),_("Custom search"));
	gtk_box_pack_start(GTK_BOX(vbox1),radio_custom_search,FALSE,FALSE,0);
	radio_remote_friend = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio_custom_search),_("Remote friends"));
	gtk_box_pack_start(GTK_BOX(vbox1),radio_remote_friend,FALSE,FALSE,0);	
	radio_group_list = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio_remote_friend),_("Show group list"));
	gtk_box_pack_start(GTK_BOX(vbox1),radio_group_list,FALSE,FALSE,0);	
	radio_group_num = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio_group_list),_("Group number"));
	gtk_box_pack_start(GTK_BOX(vbox1),radio_group_num,FALSE,FALSE,0);
	radio_create_group = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON (radio_group_num),_("Create group"));
	gtk_box_pack_start(GTK_BOX(vbox1),radio_create_group,FALSE,FALSE,0);	

	gtk_container_add(GTK_CONTAINER(frame),vbox1);
	gtk_box_pack_start(GTK_BOX(vbox),frame,FALSE,FALSE,0);
		
	GtkWidget *label;
	if (linqMain->getUDPSession()->numClients >0) {
		gchar *text;
		text = g_strdup_printf(_("Online users count:  %u"), linqMain->getUDPSession()->numClients);
		label=gtk_label_new(text);
		g_free(text);
	}
	else
		label=gtk_label_new(_("Online users count:  Unknow"));		
	
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void SearchDlg::create_nb_customSearch()
{
	GtkWidget *vbox;	
	vbox = gtk_vbox_new(FALSE,8);
	GtkWidget *label;
	label=gtk_label_new(_("Notice:\nYou can input one parameter or more to\nsearch the users\n\n"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	label=gtk_label_new(_("By user name:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	search_custom_name_entry=gtk_entry_new();	
	g_signal_connect (G_OBJECT (search_custom_name_entry), "activate",
				    G_CALLBACK(on_next_clicked), this);
	gtk_box_pack_start(GTK_BOX(vbox),search_custom_name_entry,FALSE,FALSE,0);
	label=gtk_label_new(_("By nick name:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	search_custom_nick_entry=gtk_entry_new();	
	g_signal_connect (G_OBJECT (search_custom_nick_entry), "activate",
				    G_CALLBACK(on_next_clicked), this);
	gtk_box_pack_start(GTK_BOX(vbox),search_custom_nick_entry,FALSE,FALSE,0);
	label=gtk_label_new(_("By email:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	search_custom_email_entry=gtk_entry_new();	
	g_signal_connect (G_OBJECT (search_custom_email_entry), "activate",
				    G_CALLBACK(on_next_clicked), this);
	gtk_box_pack_start(GTK_BOX(vbox),search_custom_email_entry,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void SearchDlg::create_nb_groupNUm()
{
	GtkWidget *vbox;	
	vbox = gtk_vbox_new(FALSE,8);
	GtkWidget *label;
	label=gtk_label_new(_("Notice:\nInput the group number."));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	label=gtk_label_new(_("Group number:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	group_num_entry=gtk_entry_new();	
	g_signal_connect (G_OBJECT (group_num_entry), "activate",
				    G_CALLBACK(on_next_clicked), this);
	gtk_box_pack_start(GTK_BOX(vbox),group_num_entry,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void SearchDlg::create_nb_createGroup()
{
	GtkWidget *vbox;	
	vbox = gtk_vbox_new(FALSE,8);
	GtkWidget *label;
	label=gtk_label_new(_("Notice:\nInput the group name and password."));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	label=gtk_label_new(_("Group name:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	create_group_name_entry=gtk_entry_new();	
	g_signal_connect (G_OBJECT (create_group_name_entry), "activate",
				    G_CALLBACK(on_next_clicked), this);
	gtk_box_pack_start(GTK_BOX(vbox),create_group_name_entry,FALSE,FALSE,0);
	label=gtk_label_new(_("Password:"));
	gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	create_group_password_entry=gtk_entry_new();	
	g_signal_connect (G_OBJECT (create_group_password_entry), "activate",
				    G_CALLBACK(on_next_clicked), this);
	gtk_box_pack_start(GTK_BOX(vbox),create_group_password_entry,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void SearchDlg::create_nb_createGroupResult()
{
	GtkWidget *vbox;	
	vbox = gtk_vbox_new(FALSE,8);
	create_group_result_info_label=gtk_label_new("");
	gtk_misc_set_alignment (GTK_MISC (create_group_result_info_label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox),create_group_result_info_label,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void SearchDlg::on_add_friend_send_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{
	GtkTextIter start, end;
	gtk_text_buffer_get_bounds(gtk_text_view_get_buffer(GTK_TEXT_VIEW(oSearchDlg->add_friend_textview)),&start,&end);
	gchar *reason;
	reason = gtk_text_buffer_get_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(oSearchDlg->add_friend_textview)),&start,&end,FALSE);
	const gchar *who;
	who = gtk_label_get_text(GTK_LABEL(oSearchDlg->add_friend_uin_label));
	linqMain->getUDPSession()->sendMessage(MSG_AUTH_REQUEST, who, reason);
	g_free(reason);
	gtk_label_set_text(GTK_LABEL(oSearchDlg->add_friend_info_label),_("your request is already send,you can exit now."));
	gtk_widget_set_sensitive(oSearchDlg->add_friend_hbox,FALSE);
}

void SearchDlg::create_nb_addFriend()
{
	GtkWidget *vbox;	
	vbox = gtk_vbox_new(FALSE,8);
	GtkWidget *frame;
	frame = gtk_frame_new(_("Add"));
	GtkWidget *vbox1;
	vbox1 = gtk_vbox_new(FALSE,5);
	add_friend_image = gtk_image_new();
	gtk_box_pack_start(GTK_BOX(vbox1),add_friend_image,FALSE,FALSE,0);
	add_friend_uin_label=gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(vbox1),add_friend_uin_label,FALSE,FALSE,0);
	add_friend_nick_label=gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(vbox1),add_friend_nick_label,FALSE,FALSE,5);

	gtk_container_add(GTK_CONTAINER(frame),vbox1);
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);
	
	frame = gtk_frame_new(_("Please wait"));
	vbox1 = gtk_vbox_new(FALSE,8);
	add_friend_info_label=gtk_label_new("");
	gtk_misc_set_alignment (GTK_MISC (add_friend_info_label), 0, .5);
	gtk_box_pack_start(GTK_BOX(vbox1),add_friend_info_label,FALSE,FALSE,0);
	
	add_friend_hbox = gtk_hbox_new(FALSE,8);
	
	add_friend_textview = gtk_text_view_new();
	gtk_widget_set_size_request (add_friend_textview, -1, 50);
	//sprintf(str,_("I am %s (%s),can i make friend with you?"),sd->gc->username,sd->gc->displayname);
	//gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(text)),str,-1);

	GtkWidget *scrolled_window;
	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(scrolled_window),add_friend_textview);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_IN);
	gtk_text_view_set_left_margin (GTK_TEXT_VIEW (add_friend_textview), 2);
	gtk_text_view_set_right_margin (GTK_TEXT_VIEW (add_friend_textview), 2);
	gtk_box_pack_start(GTK_BOX(add_friend_hbox),scrolled_window,TRUE,TRUE,0);
	
	GtkWidget *button;
	button = gtk_button_new_with_label(_("Send"));
	g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK(on_add_friend_send_button_clicked), this);
	gtk_box_pack_start(GTK_BOX(add_friend_hbox),button,FALSE,FALSE,0);
	
	gtk_box_pack_start(GTK_BOX(vbox1),add_friend_hbox,FALSE,FALSE,0);

	gtk_container_add(GTK_CONTAINER(frame),vbox1);
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void SearchDlg::on_user_list_detail_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{	
/*	GtkTreeModel *model;
	GtkTreeIter iter;
	
	if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->user_list_treeview)), &model, &iter))
	{
		gchar *bud;
		if (sd->nb_choose_radio == NB_CHOOSE_RADIO_LINQ_USERNAME)
		{
			bud = g_strdup(gtk_entry_get_text(GTK_ENTRY(sd->myicq_num_entry)));
		}
		else if (sd->nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
		{
			GtkTreeModel *serv_list_model;
			GtkTreeIter serv_list_iter;	
			if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->server_list_treeview)), &serv_list_model, &serv_list_iter))
			{
				gchar *domain;
				gchar *uin;
				gtk_tree_model_get (serv_list_model, &serv_list_iter,0,&domain,-1);						
				gtk_tree_model_get (model, &iter,1, &uin,-1);
				bud = g_strdup_printf("%s@%s",uin,domain);
				g_free(domain);
				g_free(uin);
			}			
		}
		else			
		{			
			gtk_tree_model_get (model, &iter,1, &bud,-1);
		}
		myicq_get_info(sd->gc,bud);
		g_free(bud);
	}*/
}

gboolean SearchDlg::on_user_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		on_user_list_detail_button_clicked(oSearchDlg->user_list_detail_button, oSearchDlg);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

void SearchDlg::on_user_list_previous_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{
	if (oSearchDlg->search_user_result_current_page == -1) // all pages
		oSearchDlg->refresh_search_user_result(0); //show the first page.
	else
		oSearchDlg->refresh_search_user_result(oSearchDlg->search_user_result_current_page-1);
}

void SearchDlg::on_user_list_next_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{
	gint total_page;
	total_page = oSearchDlg->searchUserResultPageList.size();
	if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_RANDOM_SEARCH)
	{
		if ((oSearchDlg->search_user_result_current_page == -1)||(oSearchDlg->search_user_result_current_page == total_page-1))
		{
			gtk_label_set_text(GTK_LABEL(oSearchDlg->user_list_info_label),_("Searching..."));
			gtk_widget_set_sensitive(oSearchDlg->user_list_previous_button,FALSE);
			gtk_widget_set_sensitive(oSearchDlg->user_list_next_button,FALSE);
			gtk_widget_set_sensitive(oSearchDlg->user_list_all_button,FALSE);
			linqMain->getUDPSession()->searchRandom();
		}		
		else
		{
			oSearchDlg->refresh_search_user_result(oSearchDlg->search_user_result_current_page+1);
		}
	}
	else if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_REMOTE_FRIEND)
	{
		/*if ((sd->search_user_result_current_page == -1)||(sd->search_user_result_current_page == total_page-1))
		{
			GtkTreeModel *serv_list_model;
			GtkTreeIter serv_list_iter;	
			
			if (gtk_tree_selection_get_selected (gtk_tree_view_get_selection (GTK_TREE_VIEW (sd->server_list_treeview)), &serv_list_model, &serv_list_iter))
			{
				gchar *domain;
				gtk_tree_model_get (serv_list_model, &serv_list_iter,0,&domain,-1);						

				gtk_label_set_text(GTK_LABEL(sd->user_list_info_label),_("Searching..."));
				gtk_widget_set_sensitive(sd->user_list_previous_button,FALSE);
				gtk_widget_set_sensitive(sd->user_list_next_button,FALSE);
				gtk_widget_set_sensitive(sd->user_list_all_button,FALSE);
				myicq_send_packet_searchRandom(domain,sd->gc);	
				g_free(domain);
			}			
		}		
		else
		{
			search_dialog_refresh_search_user_result(sd, sd->search_user_result_current_page+1);
		}*/
	}
	else if (oSearchDlg->nb_choose_radio == NB_CHOOSE_RADIO_CUSTOM_SEARCH)
	{
		if ((oSearchDlg->search_user_result_current_page == -1)||(oSearchDlg->search_user_result_current_page == total_page-1))
		{
			//if (oSearchDlg->customSearch_startUIN!=-1) //if equal -1,then the last search get no result,needn't search again.
			if ((oSearchDlg->search_user_result_current_page == -1)||(oSearchDlg->search_user_result_current_page == total_page-1))
			{
				gtk_label_set_text(GTK_LABEL(oSearchDlg->user_list_info_label),_("Searching..."));
				gtk_widget_set_sensitive(oSearchDlg->user_list_previous_button,FALSE);
				gtk_widget_set_sensitive(oSearchDlg->user_list_next_button,FALSE);
				gtk_widget_set_sensitive(oSearchDlg->user_list_all_button,FALSE);
				linqMain->getUDPSession()->searchUser(gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_name_entry)),gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_nick_entry)),gtk_entry_get_text(GTK_ENTRY(oSearchDlg->search_custom_email_entry)));
			}
			else
			{
				oSearchDlg->refresh_search_user_result(total_page-1);
			}
		}		
		else
		{
			oSearchDlg->refresh_search_user_result(oSearchDlg->search_user_result_current_page+1);
		}
	}
}

void SearchDlg::on_user_list_all_button_clicked (GtkWidget * widget, SearchDlg *oSearchDlg)
{
	oSearchDlg->refresh_search_user_result(-1); // -1 means all pages.
}

void SearchDlg::create_nb_userList()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE,8);
	
	GtkListStore *model;
	model = gtk_list_store_new (6,G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT,G_TYPE_INT,G_TYPE_INT,G_TYPE_INT);
	user_list_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	g_object_unref (model);
		  
	/*GtkCellRenderer *renderer_image;
	renderer_image = gtk_cell_renderer_pixbuf_new();
	GtkCellRenderer *renderer_text;
	renderer_text = gtk_cell_renderer_text_new ();
	GtkTreeViewColumn *column;
	column = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(column,_("LinQ user name"));
	gtk_tree_view_column_pack_start(column,renderer_image,FALSE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_image,
                                     "pixbuf",0);
	gtk_tree_view_column_pack_end(column,renderer_text,TRUE);
	gtk_tree_view_column_add_attribute(column,
                                     renderer_text,
                                     "text",1);
	gtk_tree_view_insert_column(GTK_TREE_VIEW(user_list_treeview),column,-1);*/


	GtkCellRenderer *renderer;	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	gint col_offset;	
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (user_list_treeview),
							    -1, _("user name"),
							    renderer, "text",
							    0,
							    NULL);
	GtkTreeViewColumn *column;
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (user_list_treeview), col_offset - 1);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (user_list_treeview),
							    -1, _("nick"),
							    renderer, "text",
							    1,
							    NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (user_list_treeview), col_offset - 1);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (user_list_treeview),
							    -1, _("status"),
							    renderer, "text",
							    2,
							    NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (user_list_treeview), col_offset - 1);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (user_list_treeview),
							    -1, _("auth"),
							    renderer, "text",
							    3,
							    NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (user_list_treeview), col_offset - 1);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);

	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (user_list_treeview),
							    -1, _("gender"),
							    renderer, "text",
							    4,
							    NULL);

	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (user_list_treeview),
							    -1, _("age"),
							    renderer, "text",
							    5,
							    NULL);

	g_signal_connect (G_OBJECT (user_list_treeview),
			"button_press_event",
			G_CALLBACK (on_user_list_button_press),
			this);
	GtkWidget *sw;	
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), user_list_treeview);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE,8);
	user_list_info_label= gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(hbox),user_list_info_label,FALSE,FALSE,0);
	user_list_previous_button = gtk_button_new_with_label(_("Previous page"));
	g_signal_connect (G_OBJECT (user_list_previous_button), "clicked",
			    G_CALLBACK(on_user_list_previous_button_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),user_list_previous_button,FALSE,FALSE,0);
	user_list_next_button = gtk_button_new_with_label(_("Next page"));
	g_signal_connect (G_OBJECT (user_list_next_button), "clicked",
			    G_CALLBACK(on_user_list_next_button_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),user_list_next_button,FALSE,FALSE,0);
	user_list_detail_button = gtk_button_new_with_label(_("Detail"));
	g_signal_connect (G_OBJECT (user_list_detail_button), "clicked",
			    G_CALLBACK(on_user_list_detail_button_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),user_list_detail_button,FALSE,FALSE,0);
	user_list_all_button = gtk_button_new_with_label(_("All pages"));
	g_signal_connect (G_OBJECT (user_list_all_button), "clicked",
			    G_CALLBACK(on_user_list_all_button_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),user_list_all_button,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

gboolean SearchDlg::on_server_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		on_next_clicked(widget,oSearchDlg);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

void SearchDlg::create_nb_serverList()
{
	GtkWidget *vbox;	
	vbox = gtk_vbox_new(FALSE,8);
	
	GtkListStore *model;
	model = gtk_list_store_new (3,G_TYPE_STRING,G_TYPE_INT,G_TYPE_STRING);
	server_list_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	g_object_unref (model);
	
	GtkCellRenderer *renderer;	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	gint col_offset;
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (server_list_treeview),
							    -1, _("MyICQ Server"),
							    renderer, "text",
							    0,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (server_list_treeview),
							    -1, _("Online user count"),
							    renderer, "text",
							    1,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (server_list_treeview),
							    -1, _("Description"),
							    renderer, "text",
							    2,
							    NULL);

	g_signal_connect (G_OBJECT (server_list_treeview),
			"button_press_event",
			G_CALLBACK (on_server_list_button_press),
			this);
	GtkWidget *sw;		
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), server_list_treeview);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);

	server_list_label= gtk_label_new(_("Reading the server list..."));
	gtk_box_pack_start(GTK_BOX(vbox),server_list_label,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

gboolean SearchDlg::on_group_type_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		on_next_clicked(widget,oSearchDlg);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

void SearchDlg::create_nb_groupTypeList()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE,8);

	GtkWidget *label;
	label= gtk_label_new(_("Please choose the group type."));
	gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
	
	GtkListStore *model;
	model = gtk_list_store_new (3,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_INT);
	
	/*grouptype_list = md->servgrouptype;
	GtkTreeIter iter;	
	GSList *grouptype_list;
	struct serv_group_type *grouptype;
	gint type_index = 0;
	while (grouptype_list)
	{
		grouptype = (struct serv_group_type *)(grouptype_list->data);
		gtk_list_store_append (model, &iter);
		gtk_list_store_set (model, &iter,
				0,grouptype->displayname,
				1,grouptype->name,
				2,type_index,
				-1);
		type_index++;
		grouptype_list = g_slist_next(grouptype_list);
	}*/
		
	group_type_list_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	g_object_unref (model);

	GtkCellRenderer *renderer;	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	gint col_offset;
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (group_type_list_treeview),
							    -1, _("Group Type"),
							    renderer, "text",
							    0,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (group_type_list_treeview),
							    -1, _("Plug-in"),
							    renderer, "text",
							    1,
							    NULL);

	g_signal_connect (G_OBJECT (group_type_list_treeview),
			"button_press_event",
			G_CALLBACK (on_group_type_list_button_press),
			this);
	GtkWidget *sw;
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), group_type_list_treeview);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

gboolean SearchDlg::on_group_list_button_press(GtkWidget * widget, GdkEventButton * event, SearchDlg *oSearchDlg)
{
	if (event->type==GDK_2BUTTON_PRESS)
	{
		on_next_clicked(widget,oSearchDlg);
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

void SearchDlg::create_nb_groupList()
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new(FALSE,8);
	
	GtkListStore *model;
	model = gtk_list_store_new (3,G_TYPE_INT,G_TYPE_STRING,G_TYPE_INT); //id,name,num
	group_list_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (model));
	g_object_unref (model);
	
	GtkCellRenderer *renderer;	
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	gint col_offset;
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (group_list_treeview),
							    -1, _("Group ID"),
							    renderer, "text",
							    0,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (group_list_treeview),
							    -1, _("Group name"),
							    renderer, "text",
							    1,
							    NULL);

	renderer = gtk_cell_renderer_text_new ();
	g_object_set (G_OBJECT (renderer), "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (group_list_treeview),
							    -1, _("Member count"),
							    renderer, "text",
							    2,
							    NULL);

	g_signal_connect (G_OBJECT (group_list_treeview),
			"button_press_event",
			G_CALLBACK (on_group_list_button_press),
			this);
	GtkWidget *sw;
	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);	
	gtk_container_add (GTK_CONTAINER (sw), group_list_treeview);
	
	gtk_box_pack_start(GTK_BOX(vbox),sw,TRUE,TRUE,0);

	group_list_info_label= gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(vbox),group_list_info_label,FALSE,FALSE,0);

	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE,8);
	GtkWidget *label;
	label= gtk_label_new(_("Password:"));
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
	group_list_password_entry = gtk_entry_new();
	g_signal_connect (G_OBJECT (group_list_password_entry), "activate",
				    G_CALLBACK(on_next_clicked), this);
	gtk_box_pack_start(GTK_BOX(hbox),group_list_password_entry,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),vbox,NULL);
}

void SearchDlg::create_notebook()
{
	notebook = gtk_notebook_new();
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook),FALSE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(notebook),FALSE);
	create_nb_choose();
	create_nb_customSearch();
	create_nb_userList();
	create_nb_addFriend();
	create_nb_serverList();
	create_nb_groupTypeList();
	create_nb_groupList();
	create_nb_groupNUm();
	create_nb_createGroup();
	create_nb_createGroupResult();
	gtk_notebook_set_current_page (GTK_NOTEBOOK (notebook), NB_CHOOSE);
	nb_current_page = NB_CHOOSE;	
}

void SearchDlg::onSearchResult(SEARCH_RESULT result[], int n)
{
	std::list< LinqSearchResult > *resultList;
	resultList = new std::list< LinqSearchResult >;
	for (int i = 0; i < n; i++) {
		resultList->push_back(result[i]);
	}
	searchUserResultPageList.push_back(resultList);
	refresh_search_user_result(searchUserResultPageList.size() -1); //show last page
}

gboolean SearchDlg::onAddContactReply(const char *name, uint8 auth)
{
	if ((nb_current_page != NB_ADD_FRIEND) && (nb_current_page != NB_USER_LIST)) {
		return false;
	}
	char msg[256];
	//switch to result page?
	switch (auth) {
	case AUTH_ACCEPTED:
		g_snprintf(msg,sizeof(msg),_("%s have accepted your add friend request."),name);
		gtk_label_set_text(GTK_LABEL(add_friend_info_label),msg);
	//add to list and update info...
		break;
	case AUTH_REJECTED:
		g_snprintf(msg,sizeof(msg),_("%s have rejected your add friend request."),name);
		gtk_label_set_text(GTK_LABEL(add_friend_info_label),msg);
		break;
	case AUTH_REQUEST:
		g_snprintf(msg,sizeof(msg),_("Authorization is required for your previous add friend request.\ntyping your auth msg if you want to add %s to your friend list."),name);
		gtk_label_set_text(GTK_LABEL(add_friend_info_label),msg);
		gtk_widget_set_sensitive(add_friend_hbox,TRUE);
		gtk_widget_show(add_friend_hbox);
		break;
	}
	return true;
}
