/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright            : (C) 2003 by Zhang Yong                         *
 *   email                : z-yong163@163.com                              *
 ***************************************************************************/

#include "messagesession.h"
#include "icqmain.h"

enum {
	TCP_CMD_MESSAGE = 0x1000,
	TCP_CMD_MESSAGE_ACK,
};


uint32 MessageSession::msg_id = 0xFfFfFfFf;


MessageSession::MessageSession(TCPSession *tcp)
{
	tcpSession = tcp;
}

uint32 MessageSession::sendMessage(const char *text)
{
	OutPacket *out = tcpSession->createPacket(TCP_CMD_MESSAGE);
	*out << --msg_id << text;
	tcpSession->sendPacket(out);

	return msg_id;
}

void MessageSession::onClose()
{
	tcpSession->destroy();
}

void MessageSession::onReceive(InPacket &in, uint16 cmd)
{
	switch (cmd) {
	case TCP_CMD_MESSAGE:
		onMessage(in);
		break;
	case TCP_CMD_MESSAGE_ACK:
		onMessageAck(in);
		break;
	}
}

void MessageSession::onMessage(InPacket &in)
{
	uint32 id;
	in >> id;

	OutPacket *out = tcpSession->createPacket(TCP_CMD_MESSAGE_ACK);
	*out << id;
	tcpSession->sendPacket(out);

	const char *text;
	in >> text;

	tcpSession->icqMain->onRecvMessage(MSG_TEXT,
		tcpSession->getContactName(), time(NULL), text);
}

void MessageSession::onMessageAck(InPacket &in)
{
	uint32 id;
	in >> id;

	tcpSession->icqMain->onAck(id);
}
