/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright            : (C) 2003 by Zhang Yong                         *
 *   email                : z-yong163@163.com                              *
 ***************************************************************************/

#include "icqpacket.h"
#include "socket.h"
#include <string.h>


ICQOutPacket::ICQOutPacket()
{
	reset();
}

OutPacket &ICQOutPacket::operator <<(uint8 b)
{
	if (getBytesAvailable() >= sizeof(b))
		*cursor++ = b;

	return (*this);
}

OutPacket &ICQOutPacket::operator <<(uint16 w)
{
	if (getBytesAvailable() >= sizeof(w)) {
		*(uint16 *) cursor = htons(w);
		cursor += sizeof(w);
	}
	return (*this);
}

OutPacket &ICQOutPacket::operator <<(uint32 dw)
{
	if (getBytesAvailable() >= sizeof(dw)) {
		*(uint32 *) cursor = htonl(dw);
		cursor += sizeof(dw);
	}
	return (*this);
}

OutPacket &ICQOutPacket::operator <<(const char *str)
{
	writeData(str, strlen(str) + 1);
	return *this;
}

void ICQOutPacket::writeData(const char *data, int n)
{
	uint16 len = n;

	if (getBytesAvailable() - n >= sizeof(len)) {
		operator <<(len);

		memcpy(cursor, data, len);
		cursor += len;
	}
}

ICQInPacket::ICQInPacket(const char *data, int n)
{
	this->data = cursor = data;
	length = n;
}

InPacket &ICQInPacket::operator >>(uint8 &b)
{
	if (getBytesAvailable() >= sizeof(b))
		b = *cursor++;
	else
		b = 0;

	return (*this);
}

InPacket &ICQInPacket::operator >>(uint16 &w)
{
	if (getBytesAvailable() >= sizeof(w)) {
		w = ntohs(*(uint16 *) cursor);
		cursor += sizeof(w);
	} else
		w = 0;
	return (*this);
}

InPacket &ICQInPacket::operator >>(uint32 &dw)
{
	if (getBytesAvailable() >= sizeof(dw)) {
		dw = ntohl(*(uint32 *) cursor);
		cursor += sizeof(dw);
	} else
		dw = 0;
	return (*this);
}

InPacket &ICQInPacket::operator >>(const char *&str)
{
	int n;
	const char *data = readData(n);

	if (n > 0 && !data[n - 1])
		str = data;
	else
		str = "";

	return (*this);
}

const char *ICQInPacket::readData(int &n)
{
	const char *data = NULL;
	n = 0;

	uint16 len;
	operator >>(len);

	if (len && getBytesAvailable() >= len) {
		n = len;
		data = cursor;
		cursor += len;
	}
	return data;
}
