# -*- coding: utf-8 -*-

from cPickle import dumps, loads
from pysqlite2 import dbapi2 as sqlite


class DB:
	def __init__ (self, name):
		self._con = sqlite.connect (name)
		self._cur = self._con.cursor ()
	
	def update_strokes (self, code, strokes):
		if strokes:
			tmp = dumps (strokes)	
		else:
			tmp = None
		sql = "UPDATE data SET strokes = ? WHERE code = ?"
		self._cur.execute (sql, (tmp, code))
		self._con.commit()

	def get_strokes (self, code):
		sql = "SELECT strokes FROM data WHERE code = ?"
		self._cur.execute (sql, (code,))
		d = self._cur.fetchall ()
		tmp = d[0][0]
		if tmp:
			return loads(tmp.encode("utf8"))
		else:
			return []
	def get_all_chars (self):
		sql = "SELECT code, ifnull(strokes != \"\",0) FROM data"
		self._cur.execute (sql)
		d = self._cur.fetchall ()
		return d
	def get_chars_by_range (self, offset, limit):
		sql = "SELECT code, ifnull(strokes !=\"\", 0) FROM data ORDER BY code LIMIT ? OFFSET ?"
		self._cur.execute (sql, (limit, offset))
		d = self._cur.fetchall ()
		return d

if __name__ == "__main__":
	db = DB("../../data/gb2312.db")
	print db.get_strokes ("我")

