#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import encodings

def gen_indic():
	if os.path.exists("../data/indic.utf"):
		return

	output = open("../data/indic.utf", 'w')
	base = 0x0900
	limit = 0x0DFF
	exclude = [0x0900]

	indicChars= []
	for charCode in range(base, limit):
		if(not (exclude.__contains__(charCode))):
			indicChars.append(encodings.codecs.utf_8_encode(unichr(charCode))[0])

	charCount = 0
	line = []
	for i in indicChars:
		line.append(i)
		charCount=(charCount+1)%20
		if(charCount==0):
			line.append('\n')
			output.write(''.join(line))
			line = []
	if line:
		line.append('\n')
		output.write(''.join(line))
	output.close()

if __name__ == "__main__":
	gen_indic()
