#!/usr/bin/env python
# -*- coding: utf-8 -*-

import SimpleXMLRPCServer
import db
import sys
from getopt import getopt

DB_NAME = "data/gb2312.db"
SERV_PORT = 1980


class StrokeServer (object):
	def __init__ (self, database = DB_NAME):
		self._db = db.DB(database)

	def get_strokes (self, code):
		return self._db.get_strokes (code)

	def update_strokes (self, code, strokes):
		self._db.update_strokes (code, strokes)
		return True

	def get_all_chars (self):
		return self._db.get_all_chars ()
	
	def get_chars_by_range (self, offset, limit):
		return self._db.get_chars_by_range (offset, limit)

def usage ():
	print "python server.py -p 1980 -d data/gb2312.db"
	print "\t -h --help		print this message"
	print "\t -p --port		specify tcp port"
	print "\t -d --database		specify database file"

def main ():
	server_port = SERV_PORT
	database = None
	try:
		opts, args = getopt (sys.argv[1:], "hp:d:", ["help","port=", "database="])
	except:
		usage ()
		sys.exit (2)
		
	for o, a in opts:
		if o in ("-h", "--help"):
			usage ()
			sys.exit ()
		if o in ("-p", "--port"):
			server_port = int (a)
		if o in ("-d", "--database"):
			database = a
	
	if database == "" or database == None:
		usage ()
		sys.exit (2)

	server = SimpleXMLRPCServer.SimpleXMLRPCServer (("0.0.0.0", server_port))
	server.register_instance (StrokeServer(database))
	try:
		server.serve_forever()
	except:
		sys.exit(0)


if __name__ == "__main__":
	main ()
