// deardragon 2000.09.26 over
/*
    Pirate Bulletin Board System
    Copyright (C) 1990, Edward Luke, lush@Athena.EE.MsState.EDU
    Eagles Bulletin Board System
    Copyright (C) 1992, Raymond Rocker, rocker@rock.b11.ingr.com
                        Guy Vega, gtvega@seabass.st.usm.edu
                        Dominic Tynes, dbtynes@seabass.st.usm.edu
    Firebird Bulletin Board System
    Copyright (C) 1996, Hsien-Tsung Chang, Smallpig.bbs@bbs.cs.ccu.edu.tw
                        Peng Piaw Foong, ppfoong@csie.ncu.edu.tw

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*/
/*
$Id: userinfo.c,v 1.1.1.1 2000/08/25 14:20:33 deardragon Exp $
*/

#include "bbs.h"

#ifndef DLM
#undef  ALLOWGAME
#endif

extern time_t login_start_time;
extern char fromhost[60];
char   * genpasswd();
char   *sysconf_str();

void disply_userinfo( struct userec *u )
{
   int     num, exp;
#ifdef REG_EXPIRED
   time_t  now;
#ifndef AUTOGETPERM   
   time_t  nextreg;
#endif
#endif
   move(2, 0);
   clrtobot();
   now = time (0);
   set_safe_record();
   prints("Ĵ     : %-14s", u->userid);
   prints("ǳ : %-20s", u->username);
   prints("     Ա : %s", (u->gender == 'M' ? "" : "Ů"));
   prints("\nʵ     : %-40s", u->realname);
   prints("   : %d/%d/%d", 
      u->birthmonth, u->birthday, u->birthyear + 1900);
   prints("\nססַ     : %-38s", u->address);
   {
      int tyear,tmonth,tday;
      tyear = u->birthyear+1900;
      tmonth = u->birthmonth;
      tday = u->birthday;
      countdays(&tyear,&tmonth,&tday,now);
      prints("ۼ : %d\n",abs(tyear));
   }
   prints("ʼ : %s\n", u->email);
   prints("ʵ E-mail  : %s\n", u->reginfo);
   if HAS_PERM (PERM_ADMINMENU)
      prints("ʺעַ : %s\n", u->ident);
   prints("ٻ : %-22s", u->lasthost);
   prints("ն˻̬ : %s\n", u->termtype);
   getdatestring(u->firstlogin,NA);
   prints("ʺŽ : %s[ %d ]\n",
      datestring,(now-(u->firstlogin))/86400);
   getdatestring(u->lastlogin,NA);
   prints(" : %s[ %d ]\n",
      datestring,(now-(u->lastlogin))/86400);
#ifndef AUTOGETPERM      
#ifndef REG_EXPIRED
   getdatestring(u->lastjustify,NA);
   prints("ȷ : %s\n",(u->lastjustify==0)? "δע" :datestring);
#else
   if(u->lastjustify == 0) prints("ȷ     : δע\n");
   else {
      prints("ȷ     : ɣЧ: ");
      nextreg = u->lastjustify + REG_EXPIRED * 86400;
      getdatestring(nextreg,NA);
      sprintf(genbuf,"%14.14s[%s] %d \n", 
         datestring ,datestring+23,(nextreg - now) / 86400);
      prints(genbuf);
   }      
#endif
#endif
   prints("Ŀ     : %d\n",u->numposts);
   prints("˽     : %d \n", u->nummails);
#ifdef ALLOWGAME
   prints("״     : ֽ %d Ԫ /  %d  /  %d Ԫ (%s)\n",
      u->money,u->medals,u->inbank,cmoney(u->money));
#endif
   prints("վ     : %d       ", u->numlogins);
   prints("վʱ   : %d  %d Сʱ %d \n",
      u->stay/86400, (u->stay/3600)%24 ,(u->stay/60)%60);
   exp = countexp(u);
   prints("ֵ       : %d  (%s)    ", exp, cexp(exp));
   exp = countperf(u);
   prints("ֵ : %d  (%s)\n", exp, cperf(exp));
   strcpy(genbuf, "bTCPRD#@XWBA#VS-DOM-F0s2345678");
   for (num = 0; num < strlen(genbuf) ; num++)
      if (!(u->userlevel & (1 << num))) genbuf[num] = '-';
   prints("ʹȨ   : %s\n", genbuf);
   prints("\n");
   if (u->userlevel & PERM_SYSOP) {
      prints("  Ǳվվ, лͶ.\n");
   } else if (u->userlevel & PERM_BOARDS) {
      prints("  Ǳվİ, лĸ.\n");
   } else if (u->userlevel & PERM_LOGINOK) {
      prints("  עѾ, ӭ뱾վ.\n");
   } else if (u->lastlogin - u->firstlogin < 3 * 86400) {
      prints("  ·, Ķ Announce .\n");
   } else {
      prints("  עδɹ, οվվ˵.\n");
   }
}

void uinfo_change1(int i, struct userec *u, struct userec *newinfo)
{
   char    buf[STRLEN], genbuf[128];

   sprintf(genbuf, "ߴ [%d]: ", u->numlogins);
   getdata(i++, 0, genbuf, buf, 10, DOECHO, YEA);
   if (buf[0]!='\0' && atoi(buf) >= 0)
      newinfo->numlogins = atoi(buf);

   sprintf(genbuf, " [%d]: ", u->numposts);
   getdata(i++, 0, genbuf, buf, 10, DOECHO, YEA);
   if (buf[0]!='\0' && atoi(buf) >= 0)
      newinfo->numposts = atoi(buf);

#ifdef ALLOWGAME
   sprintf(genbuf, "ʽ [%d]: ", u->money);
   getdata(i++, 0, genbuf, buf, 8, DOECHO, YEA);
   if (buf[0]!='\0' && atoi(buf) >= 0)
      newinfo->money = atoi(buf);

   sprintf(genbuf, "д [%d]: ", u->inbank);
   getdata(i++, 0, genbuf, buf, 8, DOECHO, YEA);
   if (buf[0]!='\0' && atoi(buf) >= 0)
  	newinfo->inbank = atoi(buf);

   sprintf(genbuf, " [%d]: ", u->medals);
   getdata(i++, 0, genbuf, buf, 10, DOECHO, YEA);
   if (buf[0]!='\0' && atoi(buf) >= 0)
       newinfo->medals = atoi(buf);
#endif
}

void check_uinfo(struct userec *u, int MUST)
{
   int changeIT = 0, changed = 0, pos = 2;
   char ans[5];
   
   while(1){  // ǳ
      changeIT = MUST || (strlen(u->username) < 2) 
               ||(strstr(u->username, "  "))||(strstr(u->username, ""));
      if(!changeIT) {
         if(changed) { pos ++; changed = 0; }
	 break;
      } else { MUST = 0; changed = 1;	 }
      getdata(pos, 0, "ǳ (Enter nickname): ", 
         u->username, NAMELEN, DOECHO, YEA);
      strcpy(uinfo.username, u->username);
      update_utmp();
   }
   while(1){ // ʵ
      changeIT = MUST || (strlen(u->realname) < 4) 
              ||(strstr(u->realname, "  "))||(strstr(u->realname, ""));
      if(!changeIT) {
         if(changed) { pos += 2; changed = 0; }
	 break;
      } else { MUST = 0; changed = 1;	 }
      move(pos, 0);
      prints("ʵ (Enter realname):\n");
      getdata(pos+1, 0, "> ", u->realname, NAMELEN, DOECHO, YEA);
   }
   while(1){ // ͨѶַ
      changeIT = MUST||(strlen(u->address)<10)
              ||(strstr(u->address,"  "))||(strstr(u->address, ""));
      if(!changeIT) {
         if(changed) { pos += 2; changed = 0; }
	 break;
      } else { MUST = 0; changed = 1;	 }
      move(pos, 0);
      prints("ͨѶַ (Enter home address)\n");
      getdata(pos+1, 0, "> ", u->address, STRLEN - 20, DOECHO, YEA);
   }
   while(1){ // ʼַ
      changeIT = MUST||(strchr(u->email, '@') == NULL);
      if(!changeIT) {
#ifdef MAILCHECK      
         if(changed) { pos += 4; changed = 0; }
#else	 
         if(changed) { pos += 3; changed = 0; }
#endif
	 break;
      } else { MUST = 0; changed = 1;	 }
      move(pos, 0);
      prints("ʽΪ: [1;37muserid@your.domain.name[m\n");
#ifdef MAILCHECK      
     prints( "[32mվѾṩ[33mʼע[32m, ͨʼٵͨע֤.[m\n");
#endif
      prints(" (ṩ߰ <Enter>)");
#ifdef MAILCHECK      
      getdata(pos+3,0,"> ",u->email,48,DOECHO, YEA);
#else	 
      getdata(pos+2,0,"> ",u->email,48,DOECHO, YEA);
#endif
      if (strchr(u->email, '@') == NULL) {
         sprintf(genbuf, "%s.bbs@%s", u->userid, BBSHOST);
	 strncpy(u->email, genbuf, 48);
      }
   }
   { // Ա
      changeIT = MUST||(strchr("MF",u->gender) == NULL);
      if(changeIT) {
         getdata(pos, 0, "Ա: M. F.Ů [M]: ", ans,2,DOECHO,YEA);
         if(ans[0]!='F'&& ans[0]!='f'||ans[0]=='m') u->gender = 'M';
         else u->gender = 'F';
	 pos ++;
      } 
   }
   while(1) { // 
      changeIT = MUST||(u->birthyear <20) ||(u->birthyear>98);
      if(!changeIT){
         if(changed){ pos ++; changed = 0;}
	 break;
      } else { MUST = 0; changed = 1;	 }
      getdata(pos, 0, "(λ): ", ans, 5, DOECHO, YEA);
      if(atoi(ans)<1920 || atoi(ans) > 1998 ) { MUST = 1; continue; }
      u->birthyear = atoi(ans) -1900;
   }
   while(1) { // 
      changeIT = MUST||(u->birthmonth <1) ||(u->birthmonth>12);
      if(!changeIT){
         if(changed){ pos ++; changed = 0;}
         break;
      } else { MUST = 0; changed = 1;	 }
      getdata(pos, 0, "·: ", ans, 3, DOECHO, YEA);
      u->birthmonth = atoi(ans);
   }
   while(1) { // 
      changeIT = MUST||(u->birthday <1) ||(u->birthday>31)
               ||(u->birthmonth<8&&!(u->birthmonth%2)||u->birthmonth>7&&(u->birthmonth%2))&&u->birthday>30 || u->birthmonth==2&&u->birthday>28;
      if(!changeIT){
         if(changed){ pos ++; changed = 0;}
         break;
      } else { MUST = 0; changed = 1;	 }
      getdata(pos, 0, "ĳ: ", ans, 3, DOECHO, YEA);
      u->birthday = atoi(ans);
   }
}


int uinfo_query(struct userec *u, int real, int unum)
{
   struct userec newinfo;
   char    ans[3], buf[STRLEN], genbuf[128];
   char    src[STRLEN], dst[STRLEN];
   int     i, fail = 0 ;
#ifdef MAILCHANGED
   int    netty_check = 0; 
#endif

   time_t  now;
   struct tm *tmnow;
   memcpy(&newinfo, u, sizeof(currentuser));
   getdata(t_lines - 1, 0, real ?
      "ѡ (0) (1)޸ (2)趨 (3)  ID ==> [0]" :
      "ѡ (0) (1)޸ (2)趨 (3) ѡǩ ==> [0]",
      ans, 2, DOECHO, YEA);
   clear();
   refresh(); 
   now = time(0);
   tmnow = localtime(&now);

   i = 3;
   move(i++, 0);
   if (ans[0] != '3' || real)
      prints("ʹߴ: %s\n", u->userid);
   switch (ans[0]) {
      case '1':
         move(1, 0);
	 prints("޸,ֱӰ <ENTER> ʹ [] ڵϡ\n"); 
	 sprintf(genbuf, "ǳ [%s]: ", u->username);
	 getdata(i++, 0, genbuf, buf, NAMELEN, DOECHO, YEA);
	 if (buf[0])
	    strncpy(newinfo.username, buf, NAMELEN);
	
	 sprintf(genbuf, "ʵ [%s]: ", u->realname);
	 getdata(i++, 0, genbuf, buf, NAMELEN, DOECHO, YEA);
	 if (buf[0]) 
	    strncpy(newinfo.realname, buf, NAMELEN); 
	 
	 sprintf(genbuf, "סַ [%s]: ", u->address);
	 getdata(i++, 0, genbuf, buf, STRLEN - 10, DOECHO, YEA);
	 if (buf[0])
	    strncpy(newinfo.address, buf, NAMELEN); 
	 
	 sprintf(genbuf, " [%s]: ", u->email);
	 getdata(i++, 0, genbuf, buf, 48, DOECHO, YEA);
	 if (buf[0]) {
#ifdef MAILCHECK	 
#ifdef MAILCHANGED
	    if(!strcmp(u->userid,currentuser.userid))netty_check = 1;
#endif
#endif
 	    strncpy(newinfo.email, buf, 48);
	 }

	 sprintf(genbuf, "ն˻̬ [%s]: ", u->termtype);
	 getdata(i++, 0, genbuf, buf, 16, DOECHO, YEA);
	 if (buf[0])
	    strncpy(newinfo.termtype, buf, 16);

         sprintf(genbuf, " [%d]: ", u->birthyear + 1900);
	 getdata(i++, 0, genbuf, buf, 5, DOECHO, YEA);
	 if (   buf[0] && atoi(buf) > 1920 && atoi(buf) < 1998)
             newinfo.birthyear = atoi(buf) - 1900;

         sprintf(genbuf, " [%d]: ", u->birthmonth);
         getdata(i++, 0, genbuf, buf, 3, DOECHO, YEA);
	 if (buf[0] && atoi(buf) >= 1 && atoi(buf) <= 12)
	    newinfo.birthmonth = atoi(buf);

         sprintf(genbuf, " [%d]: ", u->birthday);
	 getdata(i++, 0, genbuf, buf, 3, DOECHO, YEA);
	 if (buf[0] && atoi(buf) >= 1 && atoi(buf) <= 31)
	    newinfo.birthday = atoi(buf);

         sprintf(genbuf, "Ա(M.)(F.Ů) [%c]: ", u->gender);
	 getdata(i++, 0, genbuf, buf, 2, DOECHO, YEA);
	 if (buf[0]) {
	    if (strchr("MmFf", buf[0]))
	       newinfo.gender = toupper(buf[0]);
         }

	 if (real) uinfo_change1(i,u,&newinfo);
	 break;
      case '2':
         if (!real) {
	    getdata(i++, 0, "ԭ: ", buf, PASSLEN, NOECHO, YEA);
	    if (*buf == '\0' || !checkpasswd(u->passwd, buf)) {
	       prints("\n\nܱǸ, 벻ȷ\n");
	       fail++;
	       break;
	    }
	 }
	 getdata(i++, 0, "趨: ", buf, PASSLEN, NOECHO, YEA);
	 if (buf[0] == '\0') {
	    prints("\n\n趨ȡ, ʹþ\n");
	    fail++;
	    break;
	 }
	 strncpy(genbuf, buf, PASSLEN); 
	 getdata(i++, 0, ": ", buf, PASSLEN, NOECHO, YEA);
	 if (strncmp(buf, genbuf, PASSLEN)) {
	    prints("\n\nȷʧ, ޷趨롣\n");
	    fail++;
	    break;
	 }
	 buf[8] = '\0';
	 strncpy(newinfo.passwd, genpasswd(buf), ENCPASSLEN);
	 break;
      case '3':
         if (!real) {
	    sprintf(genbuf, "Ŀǰʹǩ [%d]: ", u->signature);
	    getdata(i++, 0, genbuf, buf, 16, DOECHO, YEA);
	    if (atoi(buf) > 0) newinfo.signature = atoi(buf);
	 } else {
	    struct user_info uin;
	    extern int t_cmpuids();
	    if(t_search_ulist(&uin, t_cmpuids, unum, NA, NA)!=0){
	       prints("\nԲ𣬸ûĿǰϡ");
	       fail++;
	    } else if(!strcmp(lookupuser.userid,"SYSOP")) {
	       prints("\nԲ㲻޸ SYSOP  ID");
	       fail++;
	    } else {   
	       getdata(i++,0,"µʹߴ: ",genbuf,IDLEN+1,DOECHO, YEA);
	       if (*genbuf != '\0') {
	          if (getuser(genbuf)) {
		     prints("\nԲ! Ѿͬ ID ʹ\n");
		     fail++;
		  } else {
		     strncpy(newinfo.userid, genbuf, IDLEN + 2);
		  }
	       } else fail ++;
	    }
	 }
	 break;
      default:
         clear();
	 return 0;
   }
   if (fail != 0) {
      pressreturn();
      clear();
      return 0;
   }
   if (askyn("ȷҪı", NA, YEA) == YEA) {
      if (real) {
         char    secu[STRLEN];
	 sprintf(secu, "޸ %s Ļϻ롣", u->userid);
	 securityreport(secu);
      }
      if (strcmp(u->userid, newinfo.userid)) { 
         sprintf(src, "mail/%c/%s", toupper(u->userid[0]), u->userid);
	 sprintf(dst, "mail/%c/%s", toupper(newinfo.userid[0]), newinfo.userid);
	 rename(src, dst);
	 sethomepath(src, u->userid);
	 sethomepath(dst, newinfo.userid);
	 rename(src, dst);
	 sethomefile(src, u->userid, "register");
	 unlink(src);
	 sethomefile(src, u->userid, "register.old");
	 unlink(src);
	 setuserid(unum, newinfo.userid);
      }
      if(!strcmp(u->userid, currentuser.userid)){
         extern int WishNum;
         strncpy(uinfo.username,newinfo.username,NAMELEN);
	 WishNum = 9999;
      }	 
#ifdef MAILCHECK	 
#ifdef MAILCHANGED
      if ((netty_check == 1)&&!HAS_PERM(PERM_SYSOP)) {
         sprintf(genbuf, "%s", BBSHOST);
	 if ( (!strstr(newinfo.email, genbuf)) &&
	      (!invalidaddr(newinfo.email)) &&
	      (!invalid_email(newinfo.email))) {
	    strcpy(u->email, newinfo.email);
	    send_regmail(u);
	 } else {
	    move(t_lines - 5, 0);
	    prints("\nĵʼַ [1;33m%s[m\n",newinfo.email);
	    prints("ˡܱվϣϵͳͶעţ...\n");
	    pressanykey();
	    return 0;
	 }
      }
#endif
#endif
      memcpy(u, &newinfo, (size_t)sizeof(currentuser));
#ifdef MAILCHECK
#ifdef MAILCHANGED
      if ((netty_check == 1)&&!HAS_PERM(PERM_SYSOP)) {
         newinfo.userlevel &= ~(PERM_LOGINOK | PERM_PAGE | PERM_MESSAGE);
	 sethomefile(src, newinfo.userid, "register");
	 sethomefile(dst, newinfo.userid, "register.old");
	 rename(src, dst);
      }
#endif
#endif
      substitute_record(PASSFILE, &newinfo, sizeof(newinfo), unum);
   }
   clear();
   return 0;
}

void x_info()
{
   if (!strcmp("guest", currentuser.userid)) return;
   modify_user_mode(GMENU);
   disply_userinfo(&currentuser);
   uinfo_query(&currentuser, 0, usernum);
}

void getfield(int line, char *info, char *desc, char *buf, int len)
{
   char    prompt[STRLEN];
   sprintf(genbuf, "  ԭ趨: %-46.46s [1;32m(%s)[m",
      (buf[0] == '\0') ? "(δ趨)" : buf, info);
   move(line, 0);
   prints("%s",genbuf);
   sprintf(prompt, "  %s: ", desc);
   getdata(line + 1, 0, prompt, genbuf, len, DOECHO, YEA);
   if (genbuf[0] != '\0')  strncpy(buf, genbuf, len);
   move(line, 0);
   clrtoeol();
   prints("  %s: %s\n", desc, buf);
   clrtoeol();
}

void
x_fillform()
{
   char    rname[NAMELEN], addr[STRLEN];
   char    phone[STRLEN], dept[STRLEN], assoc[STRLEN];
   char    ans[5], *mesg, *ptr;
   FILE   *fn;
   #ifndef TIMECOUNTER
   time_t  now;
   #endif
   
   if (!strcmp("guest", currentuser.userid)) return;
   modify_user_mode(NEW);
   clear();
   move(2, 0);
   clrtobot();
   if (currentuser.userlevel & PERM_LOGINOK) {
      prints("Ѿɱվʹע, ӭ뱾վ.");
      pressreturn();
      return;
   }
#ifdef PASSAFTERTHREEDAYS
   if (currentuser.lastlogin - currentuser.firstlogin < 3 * 86400) {
      prints("״ε뱾վδ(72Сʱ)...\n");
      prints("ĴϤһ£Ժдעᵥ");
      pressreturn();
      return ;
   }   
#endif      
   if ((fn = fopen("new_register", "r")) != NULL) {
      while (fgets(genbuf, STRLEN, fn) != NULL) {
         if ((ptr = strchr(genbuf, '\n')) != NULL) *ptr = '\0';
	 if (   strncmp(genbuf, "userid: ", 8) == 0 
	     && strcmp(genbuf + 8, currentuser.userid) == 0) {
	    fclose(fn);
	    prints("վδע뵥, ȵ.");
	    pressreturn();
	    return;
	 }
      }
      fclose(fn);
   }
   strncpy(rname, currentuser.realname, NAMELEN);
   strncpy(addr, currentuser.address, STRLEN-8);
   dept[0] = phone[0] = assoc[0] = '\0';
   while (1) {
      move(3, 0);
      clrtoeol();
      prints("%s , ʵдµ:\n", currentuser.userid);
      getfield(6, "", "ʵ", rname, NAMELEN);
      getfield(8, "ѧУϵ˾ְ", "ѧУϵ", dept, STRLEN);
      getfield(10, "һƺ", "Ŀǰסַ", addr, STRLEN);
      getfield(12, "ʱ", "绰", phone, STRLEN);
      getfield(14, "УѻҵѧУ", "У  ", assoc, STRLEN);
      mesg = "Ƿȷ,  Q ע (Y/N/Quit)? [Y]: ";
      getdata(t_lines - 1, 0, mesg, ans, 3, DOECHO, YEA);
      if (ans[0] == 'Q' || ans[0] == 'q') return;
      if (ans[0] != 'N' && ans[0] != 'n') break;
   }
   strncpy(currentuser.realname, rname, NAMELEN);
   strncpy(currentuser.address, addr, STRLEN-8);
   if ((fn = fopen("new_register", "a")) != NULL) {
   #ifndef TIMECOUNTER
      now = time(NULL);
      getdatestring(now,NA);
   #else
      getnowdatestring();
   #endif   
      fprintf(fn, "usernum: %d, %s\n", usernum, datestring);
      fprintf(fn, "userid: %s\n", currentuser.userid);
      fprintf(fn, "realname: %s\n", rname);
      fprintf(fn, "dept: %s\n", dept);
      fprintf(fn, "addr: %s\n", addr);
      fprintf(fn, "phone: %s\n", phone);
      fprintf(fn, "assoc: %s\n", assoc);
      fprintf(fn, "----\n");
      fclose(fn);
   }
   setuserfile(genbuf, "mailcheck");
   if ((fn = fopen(genbuf, "w")) == NULL) return;
   fprintf(fn, "usernum: %d\n", usernum);
   fclose(fn);
}
// deardragon 2000.09.26 over
